<?php

 // Wczenie wszystkich klas RAP
 
 if ($_SERVER['DOCUMENT_ROOT'] == '/Program files/WebServ/httpd') {
 	define("RDFAPI_INCLUDE_DIR", "/Program files/WebServ/httpd/phpw20/rdfapi-php/api/"); 	
 } else if ($_SERVER['DOCUMENT_ROOT'] == '/home/httpd/shuchowcom/html') {
 	define("RDFAPI_INCLUDE_DIR", "/home/httpd/shuchowcom/html/mashups/ch5/rdfapi-php/api/"); 	
 } else {
 	define("RDFAPI_INCLUDE_DIR", "/Program files/WebServ/httpd/phpw20/rdfapi-php/api/"); 	
 }
require_once(RDFAPI_INCLUDE_DIR . "RdfAPI.php");
require_once('classes/models/clsLine.php');
require_once('classes/models/clsStation.php');

//Utworzenie klienta SPARQL
$sparqlClient = ModelFactory::getDefaultModel();
$sparqlClient->load('http://space.frot.org/rdf/tube_model2.rdf');

//Utworzenie klienta MySQL
$mySQLConn = @mysql_connect("127.0.0.1", "root", "")  or die("Nie mona nawiza poczenia z serwerem MySQL.");
$db = mysql_select_db("metrolondyn", $mySQLConn) or die("Nie mona nawiza poczenia z baz danych metrolondyn.");

/*** TUTAJ ZACZYNAJ SI DEFINICJE FUNKCJI ***/
function getAllStations(&$sparqlClient) {
	
	$returnArray = array();
	$query = '
	PREFIX : <http://xmlns.com/foaf/0.1/>
	PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#>
	PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
	PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
	
	SELECT DISTINCT ?stationName ?lat ?long
	FROM <http://space.frot.org/rdf/tube_model2.rdf>
	WHERE {
		?type rdfs:type <http://www.w3.org/2003/01/geo/wgs84_pos#SpatialThing> . 
		?type :name ?stationName .
		?type geo:lat ?lat . 
		?type geo:long ?long
	} 
	ORDER BY ?stationName';
	
	$result = $sparqlClient->sparqlQuery($query);
		
	if ($result != "false") {
		foreach ($result as $station) {					
			if ($station != "") {
				$stationObj = new Station();
				$stationObj->setStationName($station['?stationName']->getLabel());	
				$stationObj->setLat($station['?lat']->getLabel());
				$stationObj->setLong($station['?long']->getLabel());
				$returnArray[$station['?stationName']->getLabel()] = $stationObj;
			}
		}
	}
		
	return $returnArray;
	
}

function getAllLines(&$sparqlClient) {

	$returnArray = array();
		
	$query = '
	PREFIX dc: <http://purl.org/dc/elements/1.1/>
	PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
	SELECT DISTINCT ?lineName
	FROM <http://space.frot.org/rdf/tube_model2.rdf>
	
	WHERE {
		?type rdfs:type <http://space.frot.org/rdf/space.owl#Tube_Line> .
   		?type dc:title ?lineName
	} 
	ORDER BY ?lineName';
			
	$result = $sparqlClient->sparqlQuery($query);
		
	if ($result != "false") {
		foreach ($result as $line) {					
			if ($line != "") {
				$lineObj = new Line();
				$lineObj->setLineName($line['?lineName']->getLabel());	
				$returnArray[$line['?lineName']->getLabel()] = $lineObj;
			}
		}
	}
	
	return $returnArray;
	
	
}

function getLinesAndStations(&$sparqlClient) {
	$returnArray = array();
	$i = 0;
		
	$query = '
	PREFIX : <http://xmlns.com/foaf/0.1/>
	PREFIX dc: <http://purl.org/dc/elements/1.1/>
	PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
	PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>

	SELECT DISTINCT ?lineName ?stationName
	FROM <http://space.frot.org/rdf/tube_model2.rdf>
	WHERE {
		?line rdfs:type <http://space.frot.org/rdf/space.owl#Tube_Line> .
		?line dc:title ?lineName .
		?line rdf:subject ?infourl .
		?infourl dc:title ?stationName
	} 
	ORDER BY ?lineName ?stationName';
			
	$result = $sparqlClient->sparqlQuery($query);
		
	if ($result != "false") {
		foreach ($result as $relationship) {					
			if ($relationship != "") {
				$returnArray[$i]['line'] = $relationship['?lineName']->getLabel();
				$returnArray[$i]['station'] = $relationship['?stationName']->getLabel();	
				$i++;
			}
		}
	}
		
	return $returnArray;
		
}

/*** TUTAJ JEST KONIEC DEFINICJI FUNKCJI ***/

/*** POCZTEK DZIAANIA KODU ***/

$linesArr = getAllLines($sparqlClient);
$stationsArr = getAllStations($sparqlClient);
$joinArr = getLinesAndStations($sparqlClient);

foreach ($linesArr as $line) {
	$sql = 'INSERT INTO linia (NazwaLinii) VALUES (\'' . addslashes($line->getLineName()) . '\')';
	$e = mysql_query($sql, $mySQLConn);
	$line->setLineId(mysql_insert_id($mySQLConn));
}

foreach ($stationsArr as $station) {
	$sql = 'INSERT INTO stacja (NazwaStacji, SzerGeogr, DlugGeogr) VALUES (\'' . addslashes($station->getStationName()) . '\', \'' . addslashes($station->getLat()) . '\', \'' . addslashes($station->getLong()) . '\')';
	$e = mysql_query($sql, $mySQLConn);
	$station->setStationId(mysql_insert_id($mySQLConn));
}

foreach ($joinArr as $key => $value) {
  $sql = 'INSERT INTO stacjelinie (IDLinii, IDStacji) VALUES (' . $linesArr[$value['line']]->getLineId() . ', ' . $stationsArr[$value['station']]->getStationId() . ')'; 
	$e = mysql_query($sql, $mySQLConn);	
}

/*** KONIEC DZIAANIA KODU ***/



?>
